from otrn_lib import read_otrn
import os


OTRN_INPUT_FILE = "example_data_to_read.otrn"

def main_read_example():

    if not os.path.exists(OTRN_INPUT_FILE):
        print(f"Error: Input file '{OTRN_INPUT_FILE}' not found.")
        print("Please run 'example_writer.py' first to generate the necessary file.")
        return

    print("--- Starting OTRN Reader Example ---")
    read_doc = read_otrn(OTRN_INPUT_FILE)
    
    print(f"\nDocument Project: {read_doc.metadata.project}")

    # --- Listing Sequence Notes ---
    print("\n" + "=" * 40)
    print("      Listing Sequence Notes")
    print("=" * 40)
    
    if read_doc.sequence.notes:
        for i, note in enumerate(read_doc.sequence.notes):
            print(f"Note #{i+1} [Sequence]")
            print(f"  Time: {note.time}s ({note.timecode or 'N/A'})")
            print(f"  Comment: {note.comment}")
            print(f"  Name: {note.name}")
            print(f"  Commenter: {note.commenter}")
            print(f"  Status: {'Complete' if note.complete else 'Pending'}")
            
            if note.range:
                print(f"  Range End: {note.timeOut}s ({note.timecodeOut or 'N/A'})")
            if note.tags:
                tag_names = ', '.join([t.name for t in note.tags])
                print(f"  Tags: {tag_names}")
            if note.replies:
                 print(f"  Replies: {len(note.replies)} total")
            print("-" * 40)
    else:
        print("No sequence notes found.")

    # --- Listing File (Clip) Notes ---
    print("\n" + "=" * 40)
    print("      Listing File (Clip) Notes")
    print("=" * 40)
    
    if read_doc.files:
        for file_obj in read_doc.files:
            print(f"File Object: {file_obj.fileName} (Clip: {file_obj.clipName or 'N/A'})")
            if file_obj.notes:
                for i, note in enumerate(file_obj.notes):
                    print(f"  Note #{i+1} [File]")
                    print(f"    Time: {note.time}s ({note.timecode or 'N/A'})")
                    print(f"    Comment: {note.comment}")
                    print(f"    Name: {note.name}")
                    print(f"    Commenter: {note.commenter}")
                print("-" * 40)
            else:
                print("  No notes found for this file.")
    else:
        print("No file objects with notes found.")
    
if __name__ == "__main__":
    main_read_example()
